/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.mc6809;

import frc.emul.api.Execution;
import frc.emul.api.IAddressBinder;
import frc.emul.api.IInstruction;
import frc.emul.api.IMemory;
import frc.emul.api.ISimulator;
import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.IPersistentObject;
import frc.emul.api.persistence.IPersistentSection;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.mc6809.Instruction;
import frc.emul.mc6809.MC6809;
import frc.emul.mc6809.Mode;
import frc.emul.mc6809.Operand;
import frc.emul.mc6809.Regs;
import frc.emul.mc6809.dasm.DasmCore;
import frc.emul.util.Utils;
import frc.emul.vectrex.PersistentSection;
import java.security.InvalidParameterException;

public final class MC6809Sim
implements ISimulator,
IPersistentObject {
    private static final boolean DEBUG = true;
    public static final boolean DEBUG_TRACE_ENTER = false;
    public static final boolean DEBUG_TRACE_CYCLES = false;
    private static final boolean DEBUG_TRACE_LEAVE = false;
    private static final boolean DEBUG_TRACE_STATES = false;
    public static final boolean DEBUG_FLEXEMU_DASM = false;
    public static final Operand[] STACK_S_REGS = new Operand[]{Operand.REG_PC, Operand.REG_U, Operand.REG_Y, Operand.REG_X, Operand.REG_DP, Operand.REG_B, Operand.REG_A, Operand.REG_CC};
    public static final Operand[] STACK_U_REGS = new Operand[]{Operand.REG_PC, Operand.REG_S, Operand.REG_Y, Operand.REG_X, Operand.REG_DP, Operand.REG_B, Operand.REG_A, Operand.REG_CC};
    private static final Object[] EXEC_ARGS = new Object[0];
    private static final int VECTOR_SWI3 = 65522;
    private static final int VECTOR_SWI2 = 65524;
    private static final int VECTOR_FIRQ = 65526;
    private static final int VECTOR_IRQ = 65528;
    private static final int VECTOR_SWI = 65530;
    private static final int VECTOR_NMI = 65532;
    private static final int VECTOR_RESET = 65534;
    private final transient MC6809 proc;
    private transient DasmCore dasm;
    private transient IMemory mem;
    private transient Regs regs;
    private transient Instruction inst;
    private transient int lastExecPC;
    private transient int cycles;
    private transient Execution outcome;
    private transient Exception lastError;
    private boolean sync;
    private boolean cwai;
    private boolean reset;
    private boolean nmi;
    private boolean firq;
    private boolean irq;
    private static /* synthetic */ int[] $SWITCH_TABLE$frc$emul$api$Execution;

    MC6809Sim(MC6809 mC6809) {
        this.proc = mC6809;
    }

    public void initialise(IAddressBinder iAddressBinder) {
        this.regs = this.proc.getRegisters();
        this.mem = this.proc.getMemory();
        this.dasm = new DasmCore(this.mem, this.regs, iAddressBinder);
    }

    public void setLineNMI(boolean bl) {
        this.nmi = bl;
    }

    public void setLineFIRQ(boolean bl) {
        this.firq = bl;
    }

    public void setLineIRQ(boolean bl) {
        this.irq = bl;
    }

    public void setLineRESET(boolean bl) {
        this.reset = bl;
    }

    public synchronized void reset() {
        this._RESET();
    }

    public void clearPendingStates() {
        this.firq = false;
        this.irq = false;
        this.nmi = false;
        this.sync = false;
        this.cwai = false;
        this.reset = false;
    }

    public synchronized Execution execute(IInstruction iInstruction) {
        Object object;
        this.lastExecPC = this.regs.PC();
        if (this.reset) {
            this.reset();
            return Execution.RESET;
        }
        if (this.nmi | this.irq | this.firq && (object = this.processPendingInterrupts()) != Execution.NORMAL) {
            this.proc.advanceCycles(this.cycles);
            return object;
        }
        if (this.sync | this.cwai) {
            this.proc.advanceCycles(1);
            return this.sync ? Execution.SYNC : Execution.CWAI;
        }
        if (iInstruction == null) {
            this.lastError = null;
            return Execution.ILLEGAL;
        }
        object = (Instruction)iInstruction;
        this.inst = object;
        this.cycles = ((Instruction)object).getBaseCycles();
        this.outcome = Execution.NORMAL;
        this.regs.advancePC(((Instruction)object).isPage0() ? 1 : 2);
        try {
            ((Instruction)object).execMethod.invoke((Object)this, EXEC_ARGS);
        }
        catch (Exception exception) {
            this.lastError = new RuntimeException("Error while executing " + ((Instruction)object).getName() + " instruction at " + Utils.hex(4, this.lastExecPC), exception);
            this.regs.setPC(this.lastExecPC);
            return Execution.FATAL_ERR;
        }
        this.proc.advanceCycles(this.cycles);
        return this.outcome;
    }

    public int getLastExecutedAddress() {
        return this.lastExecPC;
    }

    public Exception getLastError() {
        return this.lastError;
    }

    private Execution processPendingInterrupts() {
        this.cycles = 0;
        if (this.nmi) {
            this.processNMI();
            return Execution.NMI;
        }
        if (this.firq && this.processFIRQ()) {
            return Execution.FIRQ;
        }
        if (this.irq && this.processIRQ()) {
            return Execution.IRQ;
        }
        return Execution.NORMAL;
    }

    private void processNMI() {
        int n = this.regs.CC();
        if (!this.cwai) {
            this.regs.setCC(n |= 0x80);
            this.cycles += this.impl_PSH(Operand.REG_S, 255);
        }
        this.regs.setCC(n | 0x50);
        this.regs.setPC(this.mem.readU16(65532));
        this.sync = false;
        this.cwai = false;
        this.nmi = false;
        this.cycles += 7;
    }

    private boolean processFIRQ() {
        this.sync = false;
        int n = this.regs.CC();
        if ((0x40 & n) != 0) {
            return false;
        }
        if (!this.cwai) {
            this.regs.setCC(n &= 0xFFFFFF7F);
            this.cycles += this.impl_PSH(Operand.REG_S, 129);
        }
        this.regs.setCC(n | 0x50);
        this.regs.setPC(this.mem.readU16(65526));
        this.cwai = false;
        this.firq = false;
        this.cycles += 7;
        return true;
    }

    private boolean processIRQ() {
        this.sync = false;
        int n = this.regs.CC();
        if ((0x10 & n) != 0) {
            return false;
        }
        if (!this.cwai) {
            this.regs.setCC(n |= 0x80);
            this.cycles += this.impl_PSH(Operand.REG_S, 255);
        }
        this.regs.setCC(n | 0x10);
        this.regs.setPC(this.mem.readU16(65528));
        this.cwai = false;
        this.irq = false;
        this.cycles += 7;
        return true;
    }

    public void _ABX() {
        this.regs.setX(this.regs.X() + this.regs.B());
    }

    public void _ADC() {
        this.impl_ADD_SUB(true, true, true);
    }

    public void _ADD() {
        this.impl_ADD_SUB(true, true, false);
    }

    public void _AND() {
        this.impl_BITMASK(BitmaskOperation.AND);
    }

    public void _ASR() {
        this.impl_BITSHIFT(BitshiftOperation.ASR);
    }

    public void _BIT() {
        int n = this.regs.getRegS(this.inst.getOp());
        n = this.inst.getMode() == Mode.IMMEDIATE ? (n &= this.fetchS8()) : (n &= this.mem.readS8(this.decodeEffectiveAddress()));
        this.regs.setCCZ((n & 0xFF) == 0);
        this.regs.setCCN((n & 0x80) != 0);
        this.regs.clearCCV();
    }

    public void _BSR() {
        int n = this.inst.getMode() == Mode.RELATIVE8 ? this.fetchS8() : this.fetchS16();
        this.impl_JSR(this.regs.PC() + n);
    }

    public void _Bxx() {
        int n;
        int n2 = n = this.inst.getMode() == Mode.RELATIVE8 ? this.fetchS8() : this.fetchS16();
        if (MC6809Sim.evalCondition(this.inst, this.regs.CC())) {
            if (this.inst.isPage1()) {
                ++this.cycles;
            }
            this.regs.advancePC(n);
        }
    }

    public void _CLR() {
        if (this.inst.getMode() == Mode.IMPLIED) {
            this.regs.setReg(this.inst.getOp(), 0);
        } else {
            int n = this.decodeEffectiveAddress();
            this.mem.readS8(n);
            this.mem.write8(n, 0);
        }
        this.regs.setCC(0xF0 & this.regs.CC() | 4);
    }

    public void _CMP() {
        this.impl_ADD_SUB(false, false, false);
    }

    public void _COM() {
        int n;
        if (this.inst.getMode() == Mode.IMPLIED) {
            Operand operand = this.inst.getOp();
            n = ~this.regs.getRegS(operand);
            this.regs.setReg(operand, n);
        } else {
            int n2 = this.decodeEffectiveAddress();
            n = ~this.mem.readS8(n2);
            this.mem.write8(n2, n);
        }
        this.regs.setCCZ((n & 0xFF) == 0);
        this.regs.setCCN((n & 0x80) != 0);
        this.regs.clearCCV();
        this.regs.setCCC();
    }

    public void _CWAI() {
        this.cwai = true;
        int n = this.fetchU8();
        this.regs.setCC(this.regs.CC() | 0x80);
        this.impl_PSH(Operand.REG_S, 255);
        this.regs.setCC(this.regs.CC() & n);
    }

    public void _DAA() {
        int n = this.regs.A();
        if (this.regs.CCH() || (n & 0xF) > 9) {
            n += 6;
        }
        if (this.regs.CCC() || (n & 0xF0) > 144) {
            n += 96;
        }
        this.regs.setA(n);
        this.regs.setCCC(n > 255);
        this.regs.setCCZ(n == 0);
        this.regs.setCCN((n & 0x80) != 0);
    }

    public void _DEC() {
        this.regs.setCCV(-128 == this.impl_DEC_INC(-1));
    }

    public void _EOR() {
        this.impl_BITMASK(BitmaskOperation.EOR);
    }

    public void _EXG() {
        int n;
        int n2 = this.fetchU8();
        Operand operand = MC6809Sim.decodeEXG(n2, true);
        Operand operand2 = MC6809Sim.decodeEXG(n2, false);
        int n3 = operand == Operand.CONSTANT ? 65535 : this.regs.getReg16(operand, 65280);
        int n4 = n = operand2 == Operand.CONSTANT ? 65535 : this.regs.getReg16(operand2, 65280);
        if (operand != Operand.CONSTANT) {
            this.regs.setReg(operand, n);
        }
        if (operand2 != Operand.CONSTANT) {
            this.regs.setReg(operand2, n3);
        }
    }

    public void _INC() {
        this.regs.setCCV(127 == this.impl_DEC_INC(1));
    }

    public void _JMP() {
        this.regs.setPC(this.decodeEffectiveAddress());
    }

    public void _JSR() {
        this.impl_JSR(this.decodeEffectiveAddress());
    }

    public void _LD() {
        int n;
        Operand operand = this.inst.getOp();
        if (this.inst.getMode() == Mode.IMMEDIATE) {
            n = this.fetchImmediateS();
        } else {
            int n2 = this.decodeEffectiveAddress();
            n = this.inst.isTargetReg8() ? this.mem.readS8(n2) : this.mem.readS16(n2);
        }
        this.regs.setReg(operand, n);
        this.regs.setCCN(n < 0);
        this.regs.setCCZ(n == 0);
        this.regs.clearCCV();
    }

    public void _LEA() {
        Operand operand = this.inst.getOp();
        int n = this.decodeEffectiveAddress();
        this.regs.setReg(operand, n);
        if (operand == Operand.REG_X || operand == Operand.REG_Y) {
            this.regs.setCCZ(n == 0);
        }
    }

    public void _LSL() {
        this.impl_BITSHIFT(BitshiftOperation.LSL);
    }

    public void _LSR() {
        this.impl_BITSHIFT(BitshiftOperation.LSR);
    }

    public void _MUL() {
        int n = this.regs.A() * this.regs.B();
        this.regs.setD(n);
        this.regs.setCCZ(n == 0);
        this.regs.setCCC((n & 0x80) != 0);
    }

    public void _NEG() {
        if (this.inst.getMode() == Mode.IMPLIED) {
            Operand operand = this.inst.getOp();
            this.regs.setReg(operand, this.impl_NEG8(this.regs.getRegU(operand)));
        } else {
            int n = this.decodeEffectiveAddress();
            this.mem.write8(n, this.impl_NEG8(this.mem.readU8(n)));
        }
    }

    public void _NEGCOM() {
        if (this.regs.CCC()) {
            this._COM();
        } else {
            this._NEG();
        }
    }

    public void _NOP() {
    }

    public void _OR() {
        this.impl_BITMASK(BitmaskOperation.OR);
    }

    public void _PSH() {
        int n = this.fetchU8();
        this.cycles += this.impl_PSH(this.inst.getOp(), n);
    }

    public void _PUL() {
        int n = this.fetchU8();
        this.cycles += this.impl_PUL(this.inst.getOp(), n);
    }

    public void _RESET() {
        this.regs.setCC(80);
        this.regs.setDP(0);
        this.regs.setPC(this.mem.readU16(65534));
        this.clearPendingStates();
        this.outcome = Execution.RESET;
    }

    public void _ROL() {
        this.impl_BITSHIFT(BitshiftOperation.ROL);
    }

    public void _ROR() {
        this.impl_BITSHIFT(BitshiftOperation.ROR);
    }

    public void _RTI() {
        this.impl_PUL(Operand.REG_S, 1);
        if (this.regs.CCE()) {
            this.impl_PUL(Operand.REG_S, 254);
            this.cycles = 15;
        } else {
            this.impl_RTS();
            this.cycles = 6;
        }
    }

    public void _RTS() {
        this.impl_RTS();
    }

    public void _SBC() {
        this.impl_ADD_SUB(false, true, true);
    }

    public void _SEX() {
        int n = this.regs.B();
        boolean bl = n > 127;
        this.regs.setA(bl ? 255 : 0);
        this.regs.setCCN(bl);
        this.regs.setCCZ(n == 0);
    }

    public void _ST() {
        int n = this.decodeEffectiveAddress();
        int n2 = this.regs.getRegS(this.inst.getOp());
        if (this.inst.isTargetReg8()) {
            this.mem.write8(n, n2);
        } else {
            this.mem.write16(n, n2);
        }
        this.regs.setCCN(n2 < 0);
        this.regs.setCCZ(n2 == 0);
        this.regs.clearCCV();
    }

    public void _SUB() {
        this.impl_ADD_SUB(false, true, false);
    }

    public void _SWI() {
        this.regs.setCCE();
        this.impl_PSH(Operand.REG_S, 255);
        this.regs.setCCI();
        this.regs.setCCF();
        this.regs.setPC(this.mem.readU16(65530));
    }

    public void _SWIx() {
        this.regs.setCCE(true);
        this.impl_PSH(Operand.REG_S, 255);
        this.regs.setPC(this.mem.readU16(this.inst.isPage1() ? 65524 : 65522));
    }

    public void _SYNC() {
        this.sync = true;
    }

    public void _TFR() {
        int n = this.fetchU8();
        Operand operand = MC6809Sim.decodeEXG(n, false);
        if (operand != Operand.CONSTANT) {
            Operand operand2 = MC6809Sim.decodeEXG(n, true);
            if (operand2 == Operand.CONSTANT) {
                this.regs.setReg(operand, 65535);
            } else {
                this.regs.setReg(operand, this.regs.getReg16(operand2, 65280));
            }
        }
    }

    public void _TST() {
        int n = this.inst.getMode() == Mode.IMPLIED ? this.regs.getRegS(this.inst.getOp()) : this.mem.readS8(this.decodeEffectiveAddress());
        this.regs.setCCN(n < 0);
        this.regs.setCCZ(n == 0);
        this.regs.clearCCV();
    }

    protected final void impl_RTS() {
        int n = this.regs.S();
        this.regs.setPC(this.mem.readU16(n));
        this.regs.setS(n + 2);
    }

    protected final void impl_JSR(int n) {
        int n2 = this.regs.S() - 2;
        this.mem.write16(n2, this.regs.PC());
        this.regs.setS(n2);
        this.regs.setPC(n);
    }

    protected final int impl_PUL(Operand operand, int n) {
        Operand[] operandArray = operand == Operand.REG_U ? STACK_U_REGS : STACK_S_REGS;
        int n2 = this.regs.getRegU(operand);
        int n3 = 8;
        int n4 = 0;
        int n5 = 1;
        while (--n3 >= 0) {
            if ((n & n5) != 0) {
                Operand operand2 = operandArray[n3];
                if (operand2.isReg8()) {
                    ++n4;
                    this.regs.setReg(operand2, this.mem.readS8(n2++));
                } else {
                    this.regs.setReg(operand2, this.mem.readS16(n2));
                    n4 += 2;
                    n2 += 2;
                }
            }
            n5 <<= 1;
        }
        this.regs.setReg(operand, n2);
        return n4;
    }

    protected final int impl_PSH(Operand operand, int n) {
        Operand[] operandArray = operand == Operand.REG_U ? STACK_U_REGS : STACK_S_REGS;
        int n2 = this.regs.getRegU(operand);
        int n3 = 0;
        int n4 = 0;
        int n5 = 128;
        while (n5 != 0) {
            if ((n & n5) != 0) {
                Operand operand2 = operandArray[n3];
                if (operand2.isReg8()) {
                    ++n4;
                    this.mem.write8(--n2, this.regs.getRegS(operand2));
                } else {
                    n4 += 2;
                    this.mem.write16(n2 -= 2, this.regs.getRegS(operand2));
                }
            }
            ++n3;
            n5 >>= 1;
        }
        this.regs.setReg(operand, n2);
        return n4;
    }

    protected int impl_DEC_INC(int n) {
        int n2;
        int n3;
        if (this.inst.getMode() == Mode.IMPLIED) {
            Operand operand = this.inst.getOp();
            n3 = this.regs.getRegS(operand);
            n2 = n3 + n;
            this.regs.setReg(operand, n2);
        } else {
            int n4 = this.decodeEffectiveAddress();
            n3 = this.mem.readS8(n4);
            n2 = n3 + n;
            this.mem.write8(n4, n2);
        }
        this.regs.setCCZ((n2 & 0xFF) == 0);
        this.regs.setCCN((n2 & 0x80) != 0);
        return n3;
    }

    protected void impl_ADD_SUB(boolean bl, boolean bl2, boolean bl3) {
        int n;
        int n2;
        int n3;
        Operand operand = this.inst.getOp();
        boolean bl4 = operand.isReg8();
        int n4 = n3 = bl3 && this.regs.CCC() ? 1 : 0;
        if (this.inst.getMode() == Mode.IMMEDIATE) {
            n2 = bl4 ? this.fetchU8() : this.fetchU16();
        } else {
            n = this.decodeEffectiveAddress();
            n2 = bl4 ? this.mem.readU8(n) : this.mem.readU16(n);
        }
        n = this.regs.getRegU(operand);
        if (bl) {
            n2 = bl4 ? this.impl_ADD8(n, n2, n3) : this.impl_ADD16(n, n2);
        } else {
            int n5 = n2 = bl4 ? this.impl_SUB8(n, n2, n3) : this.impl_SUB16(n, n2);
        }
        if (bl2) {
            this.regs.setReg(operand, n2);
        }
    }

    protected final int impl_NEG8(int n) {
        if (n == 0) {
            this.regs.updateFlags(15, 4);
            return 0;
        }
        int n2 = 1 + (n <= 128 ? 8 : 0) + (n == 128 ? 2 : 0);
        this.regs.updateFlags(15, n2);
        return -n;
    }

    protected final int impl_SUB8(int n, int n2, int n3) {
        int n4 = n - n2 - n3;
        this.regs.setCCZ((0xFF & n4) == 0);
        this.regs.setCCC((0xFF00 & n4) != 0);
        this.regs.setCCN((0x80 & n4) != 0);
        this.regs.setCCV((0x80 & (n ^ n2 ^ n4 ^ n4 >> 1)) != 0);
        return n4;
    }

    protected final int impl_SUB16(int n, int n2) {
        int n3 = n - n2;
        this.regs.setCCZ((0xFFFF & n3) == 0);
        this.regs.setCCC((0xFFFF0000 & n3) != 0);
        this.regs.setCCN((0x8000 & n3) != 0);
        this.regs.setCCV((0x8000 & (n ^ n2 ^ n3 ^ n3 >> 1)) != 0);
        return n3;
    }

    protected final int impl_ADD8(int n, int n2, int n3) {
        int n4 = this.regs.CC() & 0xFFFFFFD0;
        int n5 = n + n2 + n3;
        if ((n & 0xF) + (n2 & 0xF) + n3 >= 16) {
            n4 |= 0x20;
        }
        if ((n & 0x7F) + (n2 & 0x7F) + n3 >= 128) {
            n4 |= 2;
        }
        if ((n5 & 0x80) != 0) {
            n4 |= 8;
        }
        if ((n5 & 0xFF) == 0) {
            n4 |= 4;
        }
        if (n5 > 255) {
            n4 ^= 3;
        }
        this.regs.setCC(n4);
        return n5;
    }

    protected final int impl_ADD16(int n, int n2) {
        int n3 = this.regs.CC() & 0xFFFFFFF0;
        int n4 = n + n2;
        if ((n & Short.MAX_VALUE) + (n2 & Short.MAX_VALUE) >= 32768) {
            n3 |= 2;
        }
        if ((n4 & 0x8000) != 0) {
            n3 |= 8;
        }
        if ((n4 & 0xFFFF) == 0) {
            n3 |= 4;
        }
        if (n4 > 65535) {
            n3 ^= 3;
        }
        this.regs.setCC(n3);
        return n4;
    }

    protected final void impl_BITMASK(BitmaskOperation bitmaskOperation) {
        Operand operand = this.inst.getOp();
        int n = this.inst.getMode() == Mode.IMMEDIATE ? this.fetchS8() : this.mem.readS8(this.decodeEffectiveAddress());
        switch (bitmaskOperation) {
            case AND: {
                n &= this.regs.getRegS(operand);
                break;
            }
            case OR: {
                n |= this.regs.getRegS(operand);
                break;
            }
            case EOR: {
                n ^= this.regs.getRegS(operand);
                break;
            }
            default: {
                throw new UnsupportedOperationException(bitmaskOperation.toString());
            }
        }
        this.regs.setReg(operand, n);
        if (operand != Operand.REG_CC) {
            this.regs.setCCN((n & 0x80) != 0);
            this.regs.setCCZ((n & 0xFF) == 0);
            this.regs.clearCCV();
        }
    }

    protected final void impl_BITSHIFT(BitshiftOperation bitshiftOperation) {
        int n;
        int n2;
        int n3;
        if (this.inst.getMode() == Mode.IMPLIED) {
            n3 = -1;
            n2 = this.regs.getRegS(this.inst.getOp());
        } else {
            n3 = this.decodeEffectiveAddress();
            n2 = this.mem.readS8(n3);
        }
        switch (bitshiftOperation) {
            case ASR: {
                n = n2 >> 1;
                break;
            }
            case LSR: {
                n = n2 >> 1 & 0x7F;
                break;
            }
            case ROR: {
                n = n2 >> 1 & 0x7F | (this.regs.CCC() ? 128 : 0);
                break;
            }
            case LSL: {
                n = n2 << 1;
                break;
            }
            case ROL: {
                n = n2 << 1 | (this.regs.CCC() ? 1 : 0);
                break;
            }
            default: {
                throw new UnsupportedOperationException(bitshiftOperation.toString());
            }
        }
        if (n3 >= 0) {
            this.mem.write8(n3, n);
        } else {
            this.regs.setReg(this.inst.getOp(), n);
        }
        switch (bitshiftOperation) {
            case ASR: 
            case LSR: 
            case ROR: {
                this.regs.setCCC((n2 & 1) != 0);
                break;
            }
            case LSL: 
            case ROL: {
                this.regs.setCCC(n2 < 0);
                this.regs.setCCV(((n2 ^ n) & 0x80) != 0);
            }
        }
        this.regs.setCCN((n & 0x80) != 0);
        this.regs.setCCZ((n & 0xFF) == 0);
    }

    private int decodeEffectiveAddress() {
        Mode mode = this.inst.getMode();
        if (mode == Mode.EXTENDED) {
            return this.fetchU16();
        }
        if (mode == Mode.DIRECT) {
            return this.regs.DP() << 8 | this.fetchU8();
        }
        if (mode == Mode.INDEXED) {
            Operand operand;
            int n;
            int n2 = this.fetchU8();
            if (n2 == 159) {
                this.cycles += 5;
                return this.mem.readU16(this.fetchU16());
            }
            boolean bl = (n2 & 0x10) != 0;
            int n3 = n = bl ? 3 : 0;
            if ((n2 & 0x8E) == 140) {
                int n4;
                if ((n2 & 1) == 0) {
                    n4 = this.fetchS8();
                    ++n;
                } else {
                    n4 = this.fetchS16();
                    n += 5;
                }
                this.cycles += n;
                return bl ? this.mem.readU16(n4) : (n4 += this.regs.PC()) & 0xFFFF;
            }
            switch (n2 & 0x60) {
                case 0: {
                    operand = Operand.REG_X;
                    break;
                }
                case 32: {
                    operand = Operand.REG_Y;
                    break;
                }
                case 64: {
                    operand = Operand.REG_U;
                    break;
                }
                case 96: {
                    operand = Operand.REG_S;
                    break;
                }
                default: {
                    throw new IllegalStateException("Dead Code");
                }
            }
            if ((n2 & 0x8C) == 128) {
                int n5;
                int n6;
                switch (n2 & 0x1F) {
                    case 0: {
                        n += 2;
                        n6 = 0;
                        n5 = 1;
                        break;
                    }
                    case 2: {
                        n += 2;
                        n6 = -1;
                        n5 = 0;
                        break;
                    }
                    case 1: 
                    case 17: {
                        n += 3;
                        n6 = 0;
                        n5 = 2;
                        break;
                    }
                    case 3: 
                    case 19: {
                        n += 3;
                        n6 = -2;
                        n5 = 0;
                        break;
                    }
                    default: {
                        throw new InvalidParameterException("Invalid addressing mode %" + Utils.bin(8, n2) + " : indirection not allowed for ,R+ or ,-R");
                    }
                }
                int n7 = this.regs.getRegU(operand) + n6;
                this.regs.setReg(operand, n7 + n5);
                this.cycles += n;
                return bl ? this.mem.readU16(n7) : n7 & 0xFFFF;
            }
            int n8 = this.regs.getRegS(operand);
            if (n2 < 128) {
                int n9 = n2 & 0x1F;
                if (n9 >= 16) {
                    n9 |= 0xFFFFFFF0;
                }
                ++this.cycles;
                return n8 + n9 & 0xFFFF;
            }
            switch (n2 & 0x8F) {
                case 132: {
                    break;
                }
                case 133: {
                    ++n;
                    n8 += Utils.extendByte(this.regs.B());
                    break;
                }
                case 134: {
                    ++n;
                    n8 += Utils.extendByte(this.regs.A());
                    break;
                }
                case 136: {
                    ++n;
                    n8 += this.fetchS8();
                    break;
                }
                case 137: {
                    n += 4;
                    n8 += this.fetchS16();
                    break;
                }
                case 139: {
                    n += 4;
                    n8 += Utils.extendWord(this.regs.D());
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported indexed addressing mode : %" + Utils.bin(8, n2));
                }
            }
            this.cycles += n;
            return bl ? this.mem.readU16(n8 & 0xFFFF) : n8 & 0xFFFF;
        }
        throw new RuntimeException("Cannot compute effective address for " + this.inst);
    }

    public static final boolean evalCondition(Instruction instruction, int n) {
        switch (instruction.getOpcode() & 0xFF) {
            case 22: 
            case 32: {
                return true;
            }
            case 33: {
                return false;
            }
            case 34: {
                return (n & 5) == 0;
            }
            case 35: {
                return (n & 5) != 0;
            }
            case 36: {
                return (n & 1) == 0;
            }
            case 37: {
                return (n & 1) != 0;
            }
            case 38: {
                return (n & 4) == 0;
            }
            case 39: {
                return (n & 4) != 0;
            }
            case 40: {
                return (n & 2) == 0;
            }
            case 41: {
                return (n & 2) != 0;
            }
            case 42: {
                return (n & 8) == 0;
            }
            case 43: {
                return (n & 8) != 0;
            }
            case 46: {
                if ((n & 4) != 0) {
                    return false;
                }
            }
            case 44: {
                int n2 = n & 0xA;
                return n2 == 0 || n2 == 10;
            }
            case 47: {
                if ((n & 4) != 0) {
                    return true;
                }
            }
            case 45: {
                int n3 = n & 0xA;
                return n3 != 0 && n3 != 10;
            }
        }
        throw new RuntimeException("Unsupported branch condition : %" + Utils.hex(2, instruction.getOpcode()));
    }

    public static final Operand decodeEXG(int n, boolean bl) {
        if (bl) {
            n >>= 4;
        }
        switch (n & 0xF) {
            case 0: {
                return Operand.REG_D;
            }
            case 1: {
                return Operand.REG_X;
            }
            case 2: {
                return Operand.REG_Y;
            }
            case 3: {
                return Operand.REG_U;
            }
            case 4: {
                return Operand.REG_S;
            }
            case 5: {
                return Operand.REG_PC;
            }
            case 8: {
                return Operand.REG_A;
            }
            case 9: {
                return Operand.REG_B;
            }
            case 10: {
                return Operand.REG_CC;
            }
            case 11: {
                return Operand.REG_DP;
            }
        }
        return Operand.CONSTANT;
    }

    private final void TRACE_STATES(Execution execution) {
    }

    private final void TRACE_ENTER() {
    }

    private final void TRACE_CYCLES() {
    }

    private final void TRACE_LEAVE() {
    }

    private int fetchU8() {
        int n = this.regs.PC();
        this.regs.setPC(n + 1);
        return this.mem.readU8(n);
    }

    private int fetchS8() {
        int n = this.regs.PC();
        this.regs.setPC(n + 1);
        return this.mem.readS8(n);
    }

    private int fetchU16() {
        int n = this.regs.PC();
        this.regs.setPC(n + 2);
        return this.mem.readU16(n);
    }

    private int fetchS16() {
        int n = this.regs.PC();
        this.regs.setPC(n + 2);
        return this.mem.readS16(n);
    }

    private int fetchImmediateS() {
        return this.inst.isTargetReg8() ? this.fetchS8() : this.fetchS16();
    }

    public IPersistentSection getSection() {
        return PersistentSection.CPU_CORE;
    }

    public void store(IPersistenceWriter iPersistenceWriter) throws PersistenceException {
        iPersistenceWriter.write(this.sync);
        iPersistenceWriter.write(this.cwai);
        iPersistenceWriter.write(this.reset);
        iPersistenceWriter.write(this.nmi);
        iPersistenceWriter.write(this.firq);
        iPersistenceWriter.write(this.irq);
    }

    public void load(IPersistenceReader iPersistenceReader) throws PersistenceException {
        this.sync = iPersistenceReader.readBool();
        this.cwai = iPersistenceReader.readBool();
        this.reset = iPersistenceReader.readBool();
        this.nmi = iPersistenceReader.readBool();
        this.firq = iPersistenceReader.readBool();
        this.irq = iPersistenceReader.readBool();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$frc$emul$api$Execution() {
        if ($SWITCH_TABLE$frc$emul$api$Execution != null) {
            return $SWITCH_TABLE$frc$emul$api$Execution;
        }
        int[] nArray = new int[Execution.values().length];
        try {
            nArray[Execution.CWAI.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Execution.FATAL_ERR.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Execution.FIRQ.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Execution.ILLEGAL.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Execution.IRQ.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Execution.NMI.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Execution.NORMAL.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Execution.RESET.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Execution.SYNC.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$frc$emul$api$Execution = nArray;
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BitmaskOperation {
        AND,
        OR,
        EOR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BitshiftOperation {
        ASR,
        LSR,
        LSL,
        ROR,
        ROL;

    }
}

